/******************************************************************************* 
 * Freescale Semiconductor Inc. 
 * (c) Copyright 2010 Freescale Semiconductor, Inc. 
 * ALL RIGHTS RESERVED. 
 ******************************************************************************** 
 Services performed by FREESCALE in this matter are performed AS IS and without  
 any warranty. CUSTOMER retains the final decision relative to the total design  
 and functionality of the end product. FREESCALE neither guarantees nor will be  
 held liable by CUSTOMER for the success of this project. 
 FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,  
 BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR  
 A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED TO THE PROJECT 
 BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT 
 SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF  
 THIS AGREEMENT. 
 
 CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or  
 actions by anyone on account of any damage, or injury, whether commercial,  
 contractual, or tortuous, rising directly or indirectly as a result of the advise 
 or assistance supplied CUSTOMER in connection with product, services or goods  
 supplied under this Agreement. 
 ******************************************************************************** 
 * File      uart.c 
 * Owner     b32543 
 * Version   0.1   
 
 * Date      Oct-19-2011 
 * Classification   Internal Use Only
 * Brief     Brief description of the file 
 ******************************************************************************** 
 * Detailed Description: 
 * 
 ******************************************************************************** 
 Revision History: 
 Version  Date        Author      Description of Changes 
 0.1     2011.10.19   b32543      Create it.
 *******************************************************************************/
#include "types.h"
#include "derivative.h"
#include "uart.h"

/******************************************************************************* 
 Function Name : InitializeUART 
 Engineer  : b32543 
 Date    : 12/12/11 
 Parameters  :UARTBaudRate baudRate: baudrate for uart    
 Modifies  : NONE 
 Returns  :  void 
 Notes    :  Initialize UART for standard I/O 
 Issues   : NONE 
 ******************************************************************************/
UARTError InitializeUART(UARTBaudRate baudRate)
{
    
    PTCDD &= (uint_8) ~(uint_8) 0x28U; /* PTC3 and PTC5 set as input ports */
    PTCPE |= 0x28U; /* PTC3 and PTC5 enable pull-up */

    SCI2S1 = 0x00U;
    (void) SCI2D; /* dummy read */
    SCI2C1 = 0x00U;
    SCI2BD = (uint_16)(24000000UL/(16UL * baudRate));
    SCI2C2 = 0x04U; /*receiver on */
    return kUARTNoError;
}
/******************************************************************************* 
 Function Name : ReadUARTN 
 Engineer  : b32543 
 Date    : 12/12/11 
 Parameters  :void* bytes: location Data stored; length: datalenth    
 Modifies  : NONE 
 Returns  :  void 
 Notes    :  receive data from Uart. 
 Issues   : NONE 
 ******************************************************************************/
UARTError ReadUARTN(void* bytes, unsigned long length)
{
    uint_8 * pRec = (uint_8 *)bytes;
    while (length--)
    {
        __RESET_WATCHDOG();
        while(!SCI2S1_RDRF)
        {
            ;
        }
        *pRec++ = SCI2D;
    }
    return kUARTNoError;
}
/******************************************************************************* 
 Function Name : DebugInfoPrint 
 Engineer  : b32543 
 Date    : 12/12/11 
 Parameters  :void    
 Modifies  : NONE 
 Returns  :  void 
 Notes    : Print debug information  
 Issues   : NONE 
 ******************************************************************************/
UARTError WriteUARTN(const void* bytes, unsigned long length)
{
    uint_8 * pSend = (uint_8 *)bytes;
    SCI2C2_TE = 1U;/* enable transmitter */
    while(length--)
    {
        __RESET_WATCHDOG();
        while(!SCI2S1_TDRE)
        {
            ;
        }
        SCI2D = *pSend++;
    }

    return kUARTNoError;
}

